#include <stdio.h>
#include <stdlib.h>
#include <limits.h>
#include <math.h>

#define MAXN 1000005
typedef long long ll;

typedef struct {
    int original_index; 
    ll x;               
    ll h;               
} Mast;

Mast masts[MAXN];
ll x_coords[MAXN];
ll h_heights[MAXN];

ll dist_left[MAXN];
ll dist_right[MAXN];
ll final_dist[MAXN];

int stack[MAXN];
int stack_top;

int compareMasts(const void *a, const void *b) {
    Mast *mastA = (Mast *)a;
    Mast *mastB = (Mast *)b;
    if (mastA->x < mastB->x) return -1;
    if (mastA->x > mastB->x) return 1;
    return 0;
}

void solve_monotonic_stack(int n) {
    for (int i = 0; i < n; i++) {
        dist_left[i] = LLONG_MAX;
        dist_right[i] = LLONG_MAX;
    }

    
    stack_top = -1;
    for (int i = 0; i < n; i++) {
        while (stack_top != -1) {
            int j = stack[stack_top];
            if (masts[j].h - masts[j].x <= masts[i].h - masts[i].x) {
                stack_top--;
            } else {
                break;
            }
        }
        
        if (stack_top != -1) {
            int j = stack[stack_top];
            
            if (masts[j].h >= masts[i].h + (masts[i].x - masts[j].x)) {
                 dist_left[i] = masts[i].x - masts[j].x;
            }
        }
        
        stack[++stack_top] = i;
    }
    
    stack_top = -1;
    for (int i = n - 1; i >= 0; i--) {
        while (stack_top != -1) {
            int j = stack[stack_top];
            if (masts[j].h + masts[j].x <= masts[i].h + masts[i].x) {
                stack_top--;
            } else {
                break;
            }
        }
        
        if (stack_top != -1) {
            int j = stack[stack_top];
            
            if (masts[j].h >= masts[i].h + (masts[j].x - masts[i].x)) {
                dist_right[i] = masts[j].x - masts[i].x;
            }
        }
        
        stack[++stack_top] = i; 
    }
    
    for (int i = 0; i < n; i++) {
        ll min_dist = LLONG_MAX;
        if (dist_left[i] != LLONG_MAX) {
            min_dist = dist_left[i];
        }
        if (dist_right[i] != LLONG_MAX && dist_right[i] < min_dist) {
            min_dist = dist_right[i];
        }

        if (min_dist == LLONG_MAX) {
            final_dist[masts[i].original_index] = -1;
        } else {
            final_dist[masts[i].original_index] = min_dist;
        }
    }
}

int main() {
    int n;
    if (scanf("%d", &n) != 1) return 1;

    for (int i = 0; i < n; i++) {
        if (scanf("%lld", &x_coords[i]) != 1) return 1;
    }

    for (int i = 0; i < n; i++) {
        if (scanf("%lld", &h_heights[i]) != 1) return 1;
        masts[i].original_index = i;
        masts[i].x = x_coords[i];
        masts[i].h = h_heights[i];
    }

    qsort(masts, n, sizeof(Mast), compareMasts);

    solve_monotonic_stack(n);

    for (int i = 0; i < n; i++) {
        printf("%lld\n", final_dist[i]);
    }

    return 0;
}